@echo off
title Install ZkSyncAgent
echo ---------------------------------------------------
echo      ZKTeco Sync Agent - Installation Script
echo ---------------------------------------------------

:: 1. Check for Admin Rights
net session >nul 2>&1
if %errorLevel% == 0 (
    goto :Admin
) else (
    echo Requesting Administrator Privileges...
    powershell -Command "Start-Process '%0' -Verb RunAs"
    exit
)

:Admin
set INSTALL_DIR=C:\ProjectWorlds\BiometricAgent

echo.
echo [1/5] Creating Installation Directory...
echo Target: %INSTALL_DIR%
if not exist "%INSTALL_DIR%" mkdir "%INSTALL_DIR%"

echo.
echo [2/5] Copying Application Files...
xcopy /Y /E /I "%~dp0*.*" "%INSTALL_DIR%\"

echo.
echo [3/5] Registering ZK SDK Libraries...
if exist "%INSTALL_DIR%\zkemkeeper.dll" (
    regsvr32 /s "%INSTALL_DIR%\zkemkeeper.dll"
    echo    SDK Registered successfully.
) else (
    echo [WARNING] zkemkeeper.dll not found. SDK might fail.
)

echo.
echo [4/5] adding Auto-Start Registry Key...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Run" /v "ZkSyncAgent" /t REG_SZ /d "\"%INSTALL_DIR%\ZkSyncAgent.exe\"" /f

echo.
echo [5/5] Creating Desktop Shortcut...
powershell "$s=(New-Object -COM WScript.Shell).CreateShortcut('%userprofile%\Desktop\ZkSyncAgent.lnk');$s.TargetPath='%INSTALL_DIR%\ZkSyncAgent.exe';$s.IconLocation='%INSTALL_DIR%\ZkSyncAgent.exe';$s.Save()"

echo.
echo ---------------------------------------------------
echo      Installation Complete!
echo ---------------------------------------------------
echo.
echo You can now find "ZkSyncAgent" on your Desktop.
echo It will start automatically when you log in.
echo.
echo Press any key to Launch Agent now...
pause >nul
start "" "%INSTALL_DIR%\ZkSyncAgent.exe"
 exit
